/* eslint-disable no-magic-numbers */
define([
    'backbone',
    'Vent',
], function(Backbone, vent) {
    'use strict';

    // TODO i am not fixing the magic number in this file because they don't make since.
    
    return Backbone.Model.extend({
        idAttribute: 'patientIdentifier',
        defaults: {
            notificationFrequency: 'Never',
            emailAllowed: false,
            emailAddress: '',
            textMsgAllowed: false,
            textMsgPhNumber: '',
        },

        // eslint-disable-next-line complexity,consistent-return
        validate: function(attribs) {
            var emailRegExp = new RegExp('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$');
            var textMsgPhoneNumberRegExp = new RegExp('^[x0-9\\.\\-\\(\\)\\+\\s]+$');
            if (attribs.emailAllowed) {
                if (attribs.emailAddress.length < 3 ||
                    attribs.emailAddress.length > 50 ||
                    !emailRegExp.test(attribs.emailAddress)
                ) {
                    // TODO??? is this because everyone has to use a VA email address... otherwise that is not true
                    return 'Email must be between 3 and 50 characters in a valid email format';
                }
            }
            if (attribs.textMsgAllowed) {
                if (attribs.textMsgPhNumber.length < 10 || attribs.textMsgPhNumber.length > 50 ||
                    attribs.textMsgPhNumber.replace(/[^0-9]/g, '').length < 10 || // this checks at least 10 numbers
                    !textMsgPhoneNumberRegExp.test(attribs.textMsgPhNumber)) {
                    
                    // eslint-disable-next-line max-len
                    return 'Phone must have a minimum of 10 digits and only contain digits and these characters: + ( ) - . x space';
                }
            }
        },
    });
});
